/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CChooseDirDialog.cpp,v 1.1 1999/09/30 05:00:14 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include <shlobj.h>

#include "CChooseDirDialog.h"
#include "CComLibrary.h"
#include "CComObject.h"
#include "CPath.h"

// From the newest SDK.

#define BIF_EDITBOX			0x0010
#define BIF_NEWDIALOGSTYLE	0x0040
#define BIF_USENEWUI		(BIF_NEWDIALOGSTYLE | BIF_EDITBOX)

_USING_PGP

// Class CChooseDirDialog member functions

void 
CChooseDirDialog::Choose(HWND parentWnd, const char *title, CPath& dir)
{
	pgpAssertStrValid(title);

	CComLibrary	comLibrary;
	IMalloc		*pMalloc1;

	PGPUInt32	result	= SHGetMalloc(&pMalloc1);

	if (result != NOERROR)
		THROW_PGPERROR(kPGPError_Win32COMOpFailed);

	CComObject<IMalloc>	pMalloc(pMalloc1);
	
	BROWSEINFO	browseInfo;
	pgpClearMemory(&browseInfo, sizeof(browseInfo));

	CPath	displayName;

	browseInfo.hwndOwner		= parentWnd;
	browseInfo.pszDisplayName	= displayName.GetBuffer(
		PFLConstants::kMaxPathLength);
	browseInfo.lpszTitle		= title;
	browseInfo.ulFlags			= BIF_RETURNONLYFSDIRS | BIF_USENEWUI;

	LPITEMIDLIST	pItemIDList	= SHBrowseForFolder(&browseInfo);
	displayName.ReleaseBuffer();

	try
	{
		if (IsNull(pItemIDList))
			THROW_PGPERROR(kPGPError_UserAbort);

		if (!SHGetPathFromIDList(pItemIDList, dir.GetBuffer(
			PFLConstants::kMaxPathLength)))
		{
			dir.ReleaseBuffer();
			THROW_PGPERROR(kPGPError_Win32COMOpFailed);
		}

		dir.ReleaseBuffer();
		pMalloc->Free(pItemIDList);
	}
	catch (CComboError&)
	{
		pMalloc->Free(pItemIDList);
		throw;
	}
}
